public class UIsArray implements UArray
{
  private int n;
  private int w;
  private int alpha;
  private int beta;
  private int[] b;

  public UIsArray()
  {
    n=0;
    w=1;
    beta=2;
    alpha=4;
    b=new int[w];
  }

  public int get(int i) 
  {
    assert(0<=i && i<n);
    return b[i];
  }

  public int size()
  {
    return n;
  }

  public int length() 
  {
    return w;
  }

  public void push_back(int e) 
  {
    if(n==w)
    {
      reallocate(beta*n);
    }
    b[n]=e;
    ++n;
  }

  public void pop_back() 
  {
    assert(n>0);
    --n;
    if(alpha*n <=w && n>0)
    {
      reallocate(beta*n);
    }
  }

  private void reallocate(int new_w)
  {
    w=new_w;
    int[] new_b=new int[new_w];
    for(int i=0; i<n; ++i)
    {
      new_b[i]=b[i];
    }
    b=new_b;
  }
  
  public void set(int i, int e) // Hier koennen auch Elemente veraendert werden
  {
    if(i<n)
    {
      b[i]=e;
    }
  }

}
